<?php 
    /**
    *
    * copyright (c) 2013-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "costanti.php";
    include "util.php";
    include "gUtil/DbManager.php";
    include "gUtil/ControlloreStringhe.php";
    include "gUtil/GeneratoreEmail.php";
    include "template/stile.php";

    $idForm                = htmlspecialchars($_POST['idForm']);
    $informazioniInserite  = htmlspecialchars($_POST['informazioniInserite']);
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $impostazioni = $geecomDb->leggiSingolaRiga("geecAd_impostazioni",1);
    
    //recupero i dati del destinatario della mail (ovvero l'email impostata per quel form)
    $datiForm = $geecomDb->leggiSingolaRiga("geec_form",$idForm);
    $destinatario = $datiForm["emailDestinatario"];
    
    $indirizzoSito = str_replace(array("http://","https://","https://www."),"",$impostazioni["urlSito"]);
    $messaggio = "Nuovo messaggio dal modulo contatti {$datiForm["nome"]} del sito {$impostazioni["titoloSito"]}"."<br><b>Contenuto del messaggio:</b><br>$informazioniInserite";
    $oggetto   = "Nuovo messaggio dal tuo sito {$impostazioni["titoloSito"]}";
    session_start();
    
    $generatoreEmail = new GeneratoreEmail("geecom@$indirizzoSito", "Geecom Cms");
    
    // prim controllo: verifica se è stato inserito codice javascript
    if(ControlloreStringhe::rilevaJavascript($_POST["informazioniInserite"]) ) {
        echo"Rilevato tentativo di cross site scripting: questa email non può essere inviata. Rimuovi il codice javascript dal testo.";
    }
    else if(isset($_SESSION["data"])) {
        $inviiMail = explode(" ",$_SESSION["data"]);
        $len = count($inviiMail);

        if($len>2) { //se sono state inviate più di tre mail 
            //controlla che le ultime tre mail sono state inviate nello stesso minuto e se siamo nello stesso minuto, se si non invierà
            //in tal caso non invierà la nuova mail
            $minutoAttuale = date("i");
            if($inviiMail[$len-3]==$inviiMail[$len-2] && $inviiMail[$len-2]==$inviiMail[$len-1] && $inviiMail[$len-1]==$minutoAttuale){ 
                echo"Superato il limite di mail inviabili in un minuto, attendi qualche istante";
                exit();
            }
        }
        
        $_SESSION["data"] = $_SESSION["data"]." ".date("i"); //aggiunge il minuto corrente nella sessione

        $generatoreEmail->invia($destinatario, $oggetto, $messaggio);
        if($datiForm["paginaRingraziamento"]!=0) {
            echo"ok";
        }
        else {
            echo $datiForm["testoMessaggioInviato"];
        }
        aggiornaContatoreInvii($geecomDb,$idForm);

    }
    else { //se non è stata inviata alcuna email finora può inviare la mail senza fare controlli
        $_SESSION["data"] = date("i"); //aggiunge il minuto corrente nella sessione
        $generatoreEmail->invia($destinatario, $oggetto, $messaggio);
        echo"ok";
        aggiornaContatoreInvii($geecomDb,$idForm);
    }
    
    function aggiornaContatoreInvii($geecomDb,$idForm) {
        $query = "UPDATE geec_form SET contatoreInvii=contatoreInvii+1 WHERE id=$idForm";
        $geecomDb->eseguiQueryLettura($query);
    }